from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static
from drf_spectacular.views import (
    SpectacularAPIView,
    SpectacularRedocView,
    SpectacularSwaggerView,
)

urlpatterns = [
    # Admin Panel
    path("admin/", admin.site.urls),

    # API Documentation
    path("api/schema/", SpectacularAPIView.as_view(), name="schema"),
    path("api/docs/", SpectacularSwaggerView.as_view(url_name="schema"), name="swagger-ui"),
    path("api/redoc/", SpectacularRedocView.as_view(url_name="schema"), name="redoc"),

    # API V1 Routes (Placeholder for App URLs)
    # Uncomment as apps are created:
    path('api/v1/accounts/', include("apps.accounts.urls")),
    path('api/v1/campaigns/', include("apps.campaigns.urls")),
    path("api/v1/tracking/", include("apps.tracking.urls")),
    path("api/v1/wallet/", include("apps.wallet.urls")),
    path("api/v1/data_processor/", include("apps.data_processor.urls")),

]

# Serve static/media files in development
if settings.DEBUG:
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)