from rest_framework import serializers
from .models import Wallet, Transaction

class TransactionSerializer(serializers.ModelSerializer):
    class Meta:
        model = Transaction
        fields = ['id', 'amount', 'transaction_type', 'description', 'created_at']

class WalletSerializer(serializers.ModelSerializer):
    # Flatten transaction history into the wallet view (optional, or via separate endpoint)
    # For performance, usually transactions are fetched via a separate paginated endpoint.
    class Meta:
        model = Wallet
        fields = ['balance', 'is_frozen', 'updated_at']

class WithdrawalRequestSerializer(serializers.Serializer):
    amount = serializers.DecimalField(max_digits=14, decimal_places=2)
    description = serializers.CharField(max_length=255, required=False, default="Cashout Request")