# Generated by Django 4.2.27 on 2025-12-30 20:31

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('campaigns', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='FunnelEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('uuid', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True)),
                ('event_type', models.CharField(choices=[('CLICK', 'Click'), ('REGISTER', 'Registration'), ('TRADE', 'Trade Executed')], default='CLICK', max_length=20)),
                ('source', models.CharField(choices=[('SYSTEM', 'System Tracking'), ('EXCEL', 'Excel Import')], default='SYSTEM', max_length=20)),
                ('metadata', models.JSONField(blank=True, default=dict)),
                ('affiliate', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('campaign', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='campaigns.campaign')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClickLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('uuid', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True)),
                ('ip_address', models.GenericIPAddressField(blank=True, null=True)),
                ('user_agent', models.TextField(blank=True, null=True)),
                ('referer', models.URLField(blank=True, max_length=500, null=True)),
                ('affiliate', models.ForeignKey(help_text='The affiliate who owns the link.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='click_logs', to=settings.AUTH_USER_MODEL)),
                ('campaign', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='click_logs', to='campaigns.campaign')),
            ],
            options={
                'ordering': ['-created_at'],
                'indexes': [models.Index(fields=['created_at'], name='tracking_cl_created_122aec_idx'), models.Index(fields=['affiliate', 'campaign'], name='tracking_cl_affilia_79e81f_idx')],
            },
        ),
    ]
