from asgiref.sync import sync_to_async
from .models import BotConfig

# We use a cached property or simple fetch to get config
# Since this is async, we need a helper to fetch it safely.

@sync_to_async
def get_bot_config():
    """
    Fetches the BotConfig singleton. Creates one with defaults if missing.
    """
    config, _ = BotConfig.objects.get_or_create(pk=1)
    return config

async def get_welcome_message(first_name: str) -> str:
    config = await get_bot_config()
    # Simple template replacement
    return config.welcome_message.replace("{first_name}", first_name)

async def get_maintenance_message() -> str:
    config = await get_bot_config()
    return config.maintenance_message

async def is_bot_active() -> bool:
    config = await get_bot_config()
    return config.is_active