from django.db import models
from django.core.exceptions import ValidationError
from apps.common.models import TimeStampedModel  # Assuming you have this from Prompt 1

class BotConfig(TimeStampedModel):
    """
    Dynamic configuration for the Telegram Bot.
    Designed as a Singleton (only one record allowed).
    """
    is_active = models.BooleanField(
        default=True, 
        help_text="If unchecked, the bot will reply with the maintenance message."
    )
    welcome_message = models.TextField(
        default="Welcome to TablighShow! 🚀\nPlease share your contact to continue.",
        help_text="Message sent when user types /start"
    )
    help_message = models.TextField(
        default="Here is how you can use this bot...",
        help_text="Message sent when user clicks Help"
    )
    maintenance_message = models.TextField(
        default="⚠️ We are currently undergoing maintenance. Please check back later.",
        help_text="Message sent when Is Active is false."
    )

    class Meta:
        verbose_name = "Bot Configuration"
        verbose_name_plural = "Bot Configuration"

    def save(self, *args, **kwargs):
        # Enforce Singleton pattern: If a config exists and this is a new creation, block it.
        if not self.pk and BotConfig.objects.exists():
            raise ValidationError("There can be only one Bot Config instance.")
        return super(BotConfig, self).save(*args, **kwargs)

    def __str__(self):
        return "Main Configuration"