import time
from typing import Callable, Dict, Any, Awaitable, Union
from aiogram import BaseMiddleware
from aiogram.types import Message, CallbackQuery
from apps.telegram_bot.loader import redis

class ThrottlingMiddleware(BaseMiddleware):
    def __init__(self, limit: int = 1):
        self.limit = limit  # Seconds between requests

    async def __call__(
        self,
        handler: Callable[[Any, Dict[str, Any]], Awaitable[Any]],
        event: Union[Message, CallbackQuery],
        data: Dict[str, Any]
    ) -> Any:
        
        # Get Telegram user ID
        user_id = event.from_user.id if event.from_user else None
        if not user_id:
            return await handler(event, data)

        # Create a redis key for throttling
        key = f"throttle:{user_id}"

        # Check if key exists
        last_request = await redis.get(key)
        if last_request:
            # If user is spamming, we can either ignore or warn. 
            # Here we just ignore the request (return None) to save resources.
            return None

        # Set key with expiration (limit)
        await redis.set(key, "1", ex=self.limit)

        return await handler(event, data)