from typing import Callable, Dict, Any, Awaitable
from aiogram import BaseMiddleware
from aiogram.types import Message, CallbackQuery
from django.contrib.auth import get_user_model
from asgiref.sync import sync_to_async

User = get_user_model()

class DjangoUserMiddleware(BaseMiddleware):
    async def __call__(
        self,
        handler: Callable[[Any, Dict[str, Any]], Awaitable[Any]],
        event: Message | CallbackQuery,
        data: Dict[str, Any]
    ) -> Any:
        
        telegram_user = data.get("event_from_user")
        if not telegram_user:
            return await handler(event, data)

        # Sync_to_async wrapper to fetch user from DB
        user = await self.get_user(telegram_user.id)
        
        # Inject user into data dict accessible in handlers
        data["user"] = user
        
        return await handler(event, data)

    @sync_to_async
    def get_user(self, telegram_id: int):
        # Assuming you have a field to link telegram_id in your User model
        # If using a separate Profile model, adjust query accordingly.
        # Here we assume username or a specific profile field stores the ID.
        try:
            # Example: Looking up by a custom field 'telegram_id' in your CustomUser model
            # Ensure your accounts.models.CustomUser has this field or similar logic.
            return User.objects.get(username=str(telegram_id)) 
        except User.DoesNotExist:
            return None