import os
from aiogram import Bot, Dispatcher
from aiogram.enums import ParseMode
from aiogram.fsm.storage.redis import RedisStorage
from aiogram.client.default import DefaultBotProperties
from django.conf import settings
from redis.asyncio import Redis

# Initialize Redis connection for FSM
redis = Redis.from_url(settings.CELERY_BROKER_URL)  # Reusing the broker URL or define specific REDIS_URL

# Initialize Storage
storage = RedisStorage(redis=redis)

# Initialize Bot
bot = Bot(
    token=os.getenv("TELEGRAM_BOT_TOKEN"),
    default=DefaultBotProperties(parse_mode=ParseMode.HTML)
)

# Initialize Dispatcher
dp = Dispatcher(storage=storage)