from aiogram import Router, types
from aiogram.filters import Command
from asgiref.sync import sync_to_async
from django.conf import settings

# Initialize Router
router = Router()

@router.message(Command("ping"))
async def cmd_ping(message: types.Message, user=None):
    """
    Health check command.
    """
    if not user or not user.is_staff:
        # Silently ignore non-admins or tell them unknown command
        return
    
    await message.answer(f"🏓 Pong! Bot is running.\nEnvironment: {settings.DJANGO_ENV}")

@router.message(Command("admin_stats"))
async def cmd_admin_stats(message: types.Message, user=None):
    """
    Quick stats for admins.
    """
    if not user or not user.is_staff:
        return

    # Example: Count total users (using sync_to_async for ORM)
    from django.contrib.auth import get_user_model
    User = get_user_model()
    
    count = await sync_to_async(User.objects.count)()
    
    await message.answer(f"📊 <b>System Stats:</b>\n\nTotal Users: {count}")