# backend/apps/campaigns/services.py
from django.db.models import QuerySet
from .models import Campaign

class CampaignService:
    @staticmethod
    def get_active_campaigns(category_slug: str = None) -> QuerySet[Campaign]:
        """
        Retrieves all active campaigns. 
        Optionally filters by category slug.
        """
        qs = Campaign.objects.filter(is_active=True).select_related('category')
        
        if category_slug:
            qs = qs.filter(category__slug=category_slug)
            
        return qs.order_by('-created_at')

    @staticmethod
    def get_campaign_by_slug(slug: str) -> Campaign:
        """
        Retrieves a single active campaign by slug.
        """
        return Campaign.objects.filter(slug=slug, is_active=True).first()