# backend/apps/campaigns/serializers.py
from rest_framework import serializers
from .models import Category, Campaign, MediaFile

class CategorySerializer(serializers.ModelSerializer):
    class Meta:
        model = Category
        fields = ['id', 'name', 'slug']


class MediaFileSerializer(serializers.ModelSerializer):
    file_url = serializers.SerializerMethodField()

    class Meta:
        model = MediaFile
        fields = ['id', 'file_type', 'file_url']

    def get_file_url(self, obj):
        request = self.context.get('request')
        if obj.file:
            return request.build_absolute_uri(obj.file.url) if request else obj.file.url
        return None


class CampaignListSerializer(serializers.ModelSerializer):
    category = CategorySerializer(read_only=True)
    cover_image_url = serializers.SerializerMethodField()

    class Meta:
        model = Campaign
        fields = [
            'id', 'title', 'slug', 'category', 'cpa_amount', 
            'cover_image_url', 'is_active'
        ]

    def get_cover_image_url(self, obj):
        request = self.context.get('request')
        if obj.cover_image:
            return request.build_absolute_uri(obj.cover_image.url) if request else obj.cover_image.url
        return None


class CampaignDetailSerializer(CampaignListSerializer):
    media_files = MediaFileSerializer(many=True, read_only=True)

    class Meta(CampaignListSerializer.Meta):
        fields = CampaignListSerializer.Meta.fields + ['description', 'target_url', 'media_files']