# backend/apps/campaigns/admin.py
from django.contrib import admin
from .models import Category, Campaign, MediaFile

class MediaFileInline(admin.TabularInline):
    model = MediaFile
    extra = 1

@admin.register(Category)
class CategoryAdmin(admin.ModelAdmin):
    list_display = ('name', 'slug', 'created_at')
    prepopulated_fields = {'slug': ('name',)}

@admin.register(Campaign)
class CampaignAdmin(admin.ModelAdmin):
    list_display = ('title', 'category', 'cpa_amount', 'is_active', 'created_at')
    list_filter = ('is_active', 'category')
    search_fields = ('title', 'slug')
    prepopulated_fields = {'slug': ('title',)}
    inlines = [MediaFileInline]

@admin.register(MediaFile)
class MediaFileAdmin(admin.ModelAdmin):
    list_display = ('campaign', 'file_type', 'created_at')
    list_filter = ('file_type',)