from rest_framework import serializers
from .models import CustomUser

class SendOTPSerializer(serializers.Serializer):
    phone_number = serializers.CharField(max_length=20)

class VerifyOTPSerializer(serializers.Serializer):
    phone_number = serializers.CharField(max_length=20)
    code = serializers.CharField(max_length=6)
    referral_code = serializers.CharField(max_length=50, required=False, allow_blank=True)

class UserSerializer(serializers.ModelSerializer):
    invited_by_phone = serializers.CharField(source='invited_by.phone_number', read_only=True)

    class Meta:
        model = CustomUser
        fields = [
            'id', 
            'phone_number', 
            'is_affiliate', 
            'is_staff',       # <--- Crucial for Admin Login logic on Frontend
            'is_superuser',   # <--- Crucial for Admin Login logic on Frontend
            'referral_code', 
            'telegram_id', 
            'invited_by_phone'
        ]
        read_only_fields = fields

class AuthResponseSerializer(serializers.Serializer):
    refresh = serializers.CharField()
    access = serializers.CharField()
    user = UserSerializer()